/*
 * Decompiled with CFR 0.152.
 */
package de.pauljako.airclient.backend;

import com.google.gson.JsonElement;
import de.craftsblock.craftscore.json.Json;
import de.craftsblock.craftscore.json.JsonParser;
import de.pauljako.airclient.ClientEntrypoint;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EGLBackend {
    public static ConcurrentLinkedQueue<Json> missedPackets = new ConcurrentLinkedQueue();
    private OkHttpClient client;
    private WebSocket socket;
    public String url = "ws://127.0.0.1:45432";

    public void connect() {
        if (this.isConnected()) {
            return;
        }
        ClientEntrypoint.LOGGER.info("Connecting to EGL");
        this.client = new OkHttpClient.Builder().connectTimeout(1L, TimeUnit.MINUTES).writeTimeout(0L, TimeUnit.MILLISECONDS).readTimeout(0L, TimeUnit.MILLISECONDS).build();
        Request request = new Request.Builder().url(this.url).build();
        EGLBackend backend = this;
        this.socket = this.client.newWebSocket(request, new WebSocketListener(){

            public void onClosed(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
                ClientEntrypoint.LOGGER.info("EGL Disconnected");
                EGLBackend.this.disconnect();
            }

            public void onFailure(@NotNull WebSocket webSocket, @NotNull Throwable t, @Nullable Response response) {
                ClientEntrypoint.LOGGER.error(t.getMessage());
            }

            public void onMessage(@NotNull WebSocket webSocket, @NotNull String text) {
                if (text.equalsIgnoreCase("ping")) {
                    EGLBackend.this.send("{}");
                    return;
                }
                try {
                    ClientEntrypoint.LOGGER.info("EGL: Send Message: {}", (Object)text);
                }
                catch (Exception e) {
                    ClientEntrypoint.LOGGER.error(e.getMessage());
                }
            }

            public void onOpen(@NotNull WebSocket webSocket, @NotNull Response response) {
                try {
                    ClientEntrypoint.LOGGER.info("EGL: Connected");
                    missedPackets.forEach(EGLBackend.this::send);
                }
                catch (Exception e) {
                    ClientEntrypoint.LOGGER.error(e.getMessage());
                }
            }
        });
    }

    public void disconnect() {
        if (!this.isConnected()) {
            return;
        }
        ClientEntrypoint.LOGGER.info("EGL: Disconnecting");
        try {
            if (this.socket != null) {
                this.socket.close(1000, "Goodbye");
            }
            this.client.dispatcher().executorService().shutdown();
            boolean success = this.client.dispatcher().executorService().awaitTermination(1L, TimeUnit.SECONDS);
            if (!success) {
                throw new IllegalStateException("The EGL Websocket could not be terminated properly!");
            }
        }
        catch (Exception e) {
            ClientEntrypoint.LOGGER.error(e.getMessage());
        }
        this.socket = null;
        this.client = null;
    }

    public void send(Json json) {
        this.send(json.toString());
    }

    public void send(String message) {
        ClientEntrypoint.LOGGER.info("EGL Backend: Sending: {}", (Object)message);
        if (this.socket != null) {
            this.socket.send(message);
        }
    }

    public void update_status(String status) {
        this.send(JsonParser.parse((String)"{}").set("command", (Object)"set_status").set("value", (Object)status));
    }

    public boolean isConnected() {
        return this.client != null;
    }

    private JsonElement bakeData(ConcurrentHashMap<String, Object> elements) {
        Json object = JsonParser.parse((String)"{}");
        elements.forEach((arg_0, arg_1) -> ((Json)object).set(arg_0, arg_1));
        return object.getObject();
    }
}

