/*
 * Decompiled with CFR 0.152.
 */
package de.pauljako.airclient.module;

import de.pauljako.airclient.module.Module;
import de.pauljako.airclient.utils.Manager;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;

public class ModuleManager
extends Manager<Class<? extends Module>, Module> {
    public boolean register(Module module) {
        return this.register(module.getClass(), module);
    }

    @Override
    public boolean register(@NotNull Class<? extends Module> type, @NotNull Module module) {
        if (this.entries.containsKey(module.getClass())) {
            this.unregister(module.getClass());
        }
        module.start();
        return super.register(type, module);
    }

    @Override
    public boolean unregister(@NotNull Class<? extends Module> module) {
        Module stopped = (Module)this.entries.remove(module);
        if (stopped == null) {
            return false;
        }
        stopped.stop();
        return true;
    }

    @Override
    public boolean unregister(Module module) {
        return this.unregister(module.getClass());
    }

    public void stop() {
        this.entries.values().forEach(Module::stop);
        this.entries.clear();
    }

    public void render(class_332 context) {
        this.entries.values().forEach(module -> module.render(context));
    }

    public void tick() {
        this.entries.values().forEach(Module::tick);
    }

    @Override
    public <T extends Module> T get(Class<T> system) {
        return (T)((Module)this.entries.get(system));
    }
}

