/*
 * Decompiled with CFR 0.152.
 */
package de.pauljako.airclient.gui.overlay;

import de.pauljako.airclient.Client;
import java.awt.Color;
import net.minecraft.class_327;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;

public abstract class Overlay {
    private final String name;
    private boolean active = true;
    private boolean shadow;
    private int x;
    private int y;
    private int color;

    public Overlay(@NotNull String name) {
        this.name = name;
        this.x = 10;
        this.y = 10;
        this.shadow = true;
        this.color = Color.WHITE.getRGB();
    }

    public abstract void tick();

    public abstract void render(class_332 var1, class_327 var2);

    public boolean shouldRenderInGui() {
        return false;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setActive(boolean active) {
        this.active = active;
        Client.instance().getConfig().set("overlays." + this.getName() + ".active", (Object)active);
        Client.instance().saveConfig();
    }

    public void toggleActive() {
        this.setActive(!this.isActive());
    }

    public boolean isActive() {
        return this.active;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setX(int x) {
        this.x = x;
        Client.instance().getConfig().set("overlays." + this.getName() + ".x", (Object)x);
        Client.instance().saveConfig();
    }

    public void setY(int y) {
        this.y = y;
        Client.instance().getConfig().set("overlays." + this.getName() + ".y", (Object)y);
        Client.instance().saveConfig();
    }

    public abstract int width(class_327 var1);

    public abstract int height(class_327 var1);

    protected final int calcLargest(class_327 font, int padding, int margin, String ... texts) {
        int width = 0;
        for (String text : texts) {
            width = Math.max(width, font.method_1727(text));
        }
        return width + padding * 2 + margin * 2;
    }

    protected final int calcHighest(class_327 font, int padding, int margin, String ... texts) {
        int height = 0;
        for (String text : texts) {
            height = Math.max(height, font.method_1713(text, font.method_1727(text)));
        }
        return height + padding * 2 + margin * 2;
    }

    protected final int calcHighest(class_327 font, int padding, int margin, int maxWidth, String ... texts) {
        int height = 0;
        for (String text : texts) {
            height = Math.max(height, font.method_1713(text, maxWidth));
        }
        return height + padding * 2 + margin * 2;
    }

    public boolean getShadow() {
        return this.shadow;
    }

    public void setShadow(boolean shadow) {
        this.shadow = shadow;
        Client.instance().getConfig().set("overlays." + this.getName() + ".shadow", (Object)shadow);
        Client.instance().saveConfig();
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int rgb) {
        this.color = rgb;
        Client.instance().getConfig().set("overlays." + this.getName() + ".color", (Object)this.color);
        Client.instance().saveConfig();
    }
}

