/*
 * Decompiled with CFR 0.152.
 */
package de.pauljako.airclient.gui.overlay.overlays;

import de.pauljako.airclient.gui.overlay.Overlay;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class KeyStrokesOverlay
extends Overlay {
    private static final ConcurrentLinkedQueue<class_304> active = new ConcurrentLinkedQueue();
    private final int margin = 1;
    private final int padding = 6;
    private Map<class_304, String> translate;
    private List<class_304> watching;
    private int height;
    private int x = -1;
    private int y = 10;

    public KeyStrokesOverlay() {
        super("keystrokes");
        class_315 options = class_310.method_1551().field_1690;
        this.watching = List.of(options.field_1894, options.field_1881, options.field_1913, options.field_1849, options.field_1886, options.field_1904);
        this.translate = Map.ofEntries(Map.entry(options.field_1886, "LMB"), Map.entry(options.field_1904, "RMB"));
    }

    @Override
    public void tick() {
        this.watching.forEach(key -> {
            boolean down = key.method_1434();
            if (down && !active.contains(key)) {
                active.add((class_304)key);
            } else if (!down) {
                active.remove(key);
            }
        });
        this.x = this.getX();
        this.y = this.getY();
    }

    @Override
    public void render(class_332 graphics, class_327 font) {
        class_315 options = class_310.method_1551().field_1690;
        int width = this.width(font);
        int leftColumn = this.calcLargest(font, options.field_1913) - 1;
        int middleColumn = this.calcLargest(font, options.field_1894, options.field_1881);
        int rightColumn = this.calcLargest(font, options.field_1849);
        this.height = this.renderKey(graphics, font, options.field_1894, this.x + leftColumn + 1, this.y, middleColumn) - 1;
        this.renderKey(graphics, font, options.field_1881, this.x + leftColumn + 1, this.y + this.height + 2, middleColumn);
        this.renderKey(graphics, font, options.field_1913, this.x, this.y + this.height + 2, leftColumn);
        this.renderKey(graphics, font, options.field_1849, this.x + leftColumn + middleColumn + 1, this.y + this.height + 2, rightColumn);
        int prevwidth = this.renderAction(graphics, font, options.field_1886, this.x, this.y + this.height * 2 + 4, width);
        this.renderAction(graphics, font, options.field_1904, this.x + prevwidth + 1, this.y + this.height * 2 + 4, width);
    }

    @Override
    public int width(class_327 font) {
        class_315 options = class_310.method_1551().field_1690;
        return this.calcLargest(font, options.field_1913) + this.calcLargest(font, options.field_1894, options.field_1881) + this.calcLargest(font, options.field_1849) - 2;
    }

    @Override
    public int height(class_327 font) {
        return this.height * 3 + 6;
    }

    private int calcLargest(class_327 font, class_304 ... keys) {
        int width = 0;
        for (class_304 key : keys) {
            String text = key.method_1431();
            int textWidth = font.method_1727(text);
            width = Math.max(width, Math.max(textWidth, font.method_1713(text, textWidth)));
        }
        if (width % 2 != 0) {
            ++width;
        }
        return width;
    }

    private int renderKey(class_332 graphics, class_327 font, class_304 key, int x, int y, int columnWidth) {
        String text = this.translate.getOrDefault(key, key.method_16007().getString());
        int textWidth = font.method_1727(text);
        int textHeight = font.method_1713(text, textWidth) + 2;
        int widgetWidth = Math.max(Math.max(textHeight, textWidth), columnWidth - 14);
        graphics.method_25294(x, y, x + widgetWidth + 12, y + textHeight + 12, new Color(64, 64, 64, active.contains(key) ? 175 : 75).getRGB());
        int extraPadding = Math.max(0, widgetWidth > textWidth ? (widgetWidth - textHeight) / 2 - textWidth / 2 : 0);
        graphics.method_51433(font, text, x + extraPadding + (textWidth > textHeight ? 1 : 3) + 6, y + 6 + 2, Color.WHITE.getRGB(), this.getShadow());
        return textHeight + 12;
    }

    private int renderAction(class_332 graphics, class_327 font, class_304 key, int x, int y, int width) {
        String text = this.translate.getOrDefault(key, key.method_16007().getString());
        int textWidth = font.method_1727(text);
        int textHeight = font.method_1713(text, textWidth) + 2;
        graphics.method_25294(x, y, x + (width /= 2), y + textHeight + 12, new Color(64, 64, 64, active.contains(key) ? 175 : 75).getRGB());
        graphics.method_51433(font, text, x + width / 2 - textWidth / 2, y + 6 + 2, Color.WHITE.getRGB(), this.getShadow());
        return width;
    }
}

