/*
 * Decompiled with CFR 0.152.
 */
package de.pauljako.airclient.cosmetics.capes;

import de.craftsblock.craftscore.json.Json;
import de.craftsblock.craftscore.json.JsonParser;
import de.pauljako.airclient.cosmetics.capes.Cape;
import de.pauljako.airclient.cosmetics.capes.CapeManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class JsonCapeLoader {
    public JsonCapeLoader(CapeManager capeManager, String filePath) {
        Json jsonData = this.loadJson(filePath);
        if (jsonData == null) {
            return;
        }
        List<Cape> capeList = this.listOfCapes(jsonData);
        for (Cape cape : capeList) {
            capeManager.addCape(cape);
        }
    }

    public static void loadCapes(CapeManager capeManager, String filePath) {
        new JsonCapeLoader(capeManager, filePath);
    }

    public Json loadJson(String filePath) {
        Json json;
        block8: {
            InputStream stream = Objects.requireNonNull(JsonCapeLoader.class.getClassLoader().getResourceAsStream(filePath));
            try {
                json = JsonParser.parse((InputStream)stream);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            stream.close();
        }
        return json;
    }

    public List<Cape> listOfCapes(Json jsonData) {
        Collection capeList = jsonData.getJsonList("capes");
        ArrayList<Cape> capeObjects = new ArrayList<Cape>();
        for (Json jsonCape : capeList) {
            Collection framesList = jsonCape.getStringList("frames");
            Cape cape = framesList.size() == 1 ? new Cape(jsonCape.getString("name"), (String)framesList.stream().findFirst().get()) : (jsonCape.contains("delay") ? new Cape(jsonCape.getString("name"), jsonCape.getInt("delay"), framesList.toArray(new String[0])) : new Cape(jsonCape.getString("name"), framesList.toArray(new String[0])));
            capeObjects.add(cape);
        }
        return capeObjects;
    }
}

