/*
 * Decompiled with CFR 0.152.
 */
package de.pauljako.airclient.cosmetics;

import com.google.gson.JsonElement;
import de.craftsblock.craftscore.event.EventHandler;
import de.craftsblock.craftscore.event.ListenerAdapter;
import de.craftsblock.craftscore.json.Json;
import de.craftsblock.craftscore.json.JsonParser;
import de.craftsblock.craftscore.utils.id.Snowflake;
import de.pauljako.airclient.Client;
import de.pauljako.airclient.ClientEntrypoint;
import de.pauljako.airclient.backend.BackendCallback;
import de.pauljako.airclient.backend.events.BackendMessageReceivedEvent;
import de.pauljako.airclient.backend.events.BackendReadyEvent;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class CosmeticListener
implements ListenerAdapter {
    public static final ConcurrentHashMap<Long, BackendCallback> callbacks = new ConcurrentHashMap();

    @EventHandler
    public void handleBackendConnect(BackendReadyEvent event) {
        ClientEntrypoint.LOGGER.info("Backend: Ready");
        ConcurrentHashMap<String, Object> data = new ConcurrentHashMap<String, Object>();
        data.put("data", Collections.emptyList());
        event.getBackend().sendCosmetics(data);
        Client.instance().getCapeManager().webCapeLoader.allCapes(event.getBackend());
    }

    @EventHandler
    public void handleBackendMessage(BackendMessageReceivedEvent event) {
        ClientEntrypoint.LOGGER.info("Backend Send Message: {}", (Object)event.getMessage());
        Json json = JsonParser.parse((String)event.getMessage());
        if (json.contains("search") || json.contains("all")) {
            this.handleCosmeticSearch(json);
            return;
        }
        if (!json.contains("data") && !json.contains("uuid")) {
            return;
        }
        if (json.contains("uuid")) {
            this.updateCosmetics(UUID.fromString(json.getString("uuid")), json);
            return;
        }
        JsonElement data = json.get("data");
        if (!data.isJsonArray()) {
            return;
        }
        for (JsonElement element : data.getAsJsonArray()) {
            Json target = JsonParser.parse((JsonElement)element);
            this.updateCosmetics(UUID.fromString(target.getString("uuid")), target);
        }
    }

    private void updateCosmetics(UUID uuid, Json json) {
        if (!json.contains("cosmetics")) {
            return;
        }
        if ((json = JsonParser.parse((JsonElement)json.get("cosmetics"))).contains("cape")) {
            Client.instance().getCapeManager().setForPlayer(uuid, json.getString("cape"));
        }
        if (json.contains("prefix")) {
            Client.instance().getPrefixManager().setForPlayer(uuid, json.getString("prefix"));
        }
    }

    private void handleCosmeticSearch(Json json) {
        long id = json.getLong("id");
        BackendCallback callback = callbacks.get(id);
        if (callback == null) {
            return;
        }
        callbacks.remove(id);
        JsonElement result = json.get("result");
        boolean success = result.isJsonObject();
        callback.onResult(success, success ? JsonParser.parse((JsonElement)result) : null);
    }

    public static long addCosmeticCallback(BackendCallback callback) {
        long id = Snowflake.generate();
        if (callback != null) {
            callbacks.put(id, callback);
        }
        return id;
    }
}

