/*
 * Decompiled with CFR 0.152.
 */
package de.pauljako.airclient.backend;

import com.google.gson.JsonElement;
import de.craftsblock.craftscore.event.Event;
import de.craftsblock.craftscore.event.ListenerRegistry;
import de.craftsblock.craftscore.json.Json;
import de.craftsblock.craftscore.json.JsonParser;
import de.pauljako.airclient.Client;
import de.pauljako.airclient.ClientEntrypoint;
import de.pauljako.airclient.backend.events.BackendFailureEvent;
import de.pauljako.airclient.backend.events.BackendMessageReceivedEvent;
import de.pauljako.airclient.backend.events.BackendReadyEvent;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_310;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Backend {
    public static ConcurrentLinkedQueue<Json> missedPackets = new ConcurrentLinkedQueue();
    private OkHttpClient client;
    private WebSocket socket;
    public String url = "wss://api.airclient.pauljako.de/v1/cosmetic";
    private ListenerRegistry listenerRegistry = Client.listeners;

    public void connect() {
        if (this.isConnected()) {
            return;
        }
        ClientEntrypoint.LOGGER.info("Connecting to Backend");
        if (this.listenerRegistry == null) {
            this.listenerRegistry = Client.listeners;
        }
        this.client = new OkHttpClient.Builder().connectTimeout(1L, TimeUnit.MINUTES).writeTimeout(0L, TimeUnit.MILLISECONDS).readTimeout(0L, TimeUnit.MILLISECONDS).build();
        Request request = new Request.Builder().url(this.url).build();
        final Backend backend = this;
        this.socket = this.client.newWebSocket(request, new WebSocketListener(){

            public void onClosed(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
                ClientEntrypoint.LOGGER.info("Backend Closed");
                Backend.this.disconnect();
            }

            public void onFailure(@NotNull WebSocket webSocket, @NotNull Throwable t, @Nullable Response response) {
                try {
                    Backend.this.listenerRegistry.call((Event)new BackendFailureEvent());
                }
                catch (Exception e) {
                    ClientEntrypoint.LOGGER.error(e.getMessage());
                }
            }

            public void onMessage(@NotNull WebSocket webSocket, @NotNull String text) {
                if (text.equalsIgnoreCase("ping")) {
                    Backend.this.send("{}");
                    return;
                }
                try {
                    ClientEntrypoint.LOGGER.info("Backend: Send Message: {}", (Object)text);
                    Backend.this.listenerRegistry.call((Event)new BackendMessageReceivedEvent(text));
                }
                catch (Exception e) {
                    ClientEntrypoint.LOGGER.error(e.getMessage());
                }
            }

            public void onOpen(@NotNull WebSocket webSocket, @NotNull Response response) {
                try {
                    ClientEntrypoint.LOGGER.info("Backend: Connected");
                    missedPackets.forEach(Backend.this::send);
                    Backend.this.listenerRegistry.call((Event)new BackendReadyEvent(backend));
                }
                catch (Exception e) {
                    ClientEntrypoint.LOGGER.error(e.getMessage());
                }
            }
        });
    }

    public void disconnect() {
        if (!this.isConnected()) {
            return;
        }
        ClientEntrypoint.LOGGER.info("Backend: Disconnecting");
        if (this.listenerRegistry == null) {
            this.listenerRegistry = Client.listeners;
        }
        try {
            if (this.socket != null) {
                this.socket.close(1000, "Goodbye");
            }
            this.client.dispatcher().executorService().shutdown();
            boolean success = this.client.dispatcher().executorService().awaitTermination(1L, TimeUnit.SECONDS);
            if (!success) {
                throw new IllegalStateException("The Websocket could not be terminated properly!");
            }
        }
        catch (Exception e) {
            ClientEntrypoint.LOGGER.error(e.getMessage());
        }
        this.socket = null;
        this.client = null;
    }

    public void sendCosmetics() {
        this.sendCosmetics(null);
    }

    public void sendCosmetics(ConcurrentHashMap<String, Object> additional) {
        UUID uuid = class_310.method_1551().method_53462().getId();
        ConcurrentHashMap<String, Object> cosmetics = new ConcurrentHashMap<String, Object>();
        cosmetics.put("cape", Client.instance().getCapeManager().getForPlayer(uuid) == null ? "none" : Client.instance().getCapeManager().getForPlayer(uuid).getName());
        cosmetics.put("prefix", Client.instance().getPrefixManager().getForPlayer(uuid) == null ? "" : Client.instance().getPrefixManager().getForPlayer(uuid));
        cosmetics.put("ears", Client.instance().getEarManager().getForPlayer(uuid) != null && Client.instance().getEarManager().getForPlayer(uuid) != false);
        Json json = JsonParser.parse((String)"{}");
        json.set("uuid", (Object)uuid.toString());
        json.set("cosmetics", (Object)this.bakeData(cosmetics));
        if (additional != null) {
            additional.forEach((arg_0, arg_1) -> ((Json)json).set(arg_0, arg_1));
        }
        this.send(json);
    }

    public void send(Json json) {
        this.send(json.toString());
    }

    public void send(String message) {
        ClientEntrypoint.LOGGER.info("Backend: Sending: {}", (Object)message);
        if (this.socket != null) {
            this.socket.send(message);
        }
    }

    public boolean isConnected() {
        return this.client != null;
    }

    private JsonElement bakeData(ConcurrentHashMap<String, Object> elements) {
        Json object = JsonParser.parse((String)"{}");
        elements.forEach((arg_0, arg_1) -> ((Json)object).set(arg_0, arg_1));
        return object.getObject();
    }
}

