/*
 * Decompiled with CFR 0.152.
 */
package de.pauljako.airclient.cosmetics.capes;

import com.google.gson.JsonElement;
import de.craftsblock.craftscore.json.Json;
import de.craftsblock.craftscore.json.JsonParser;
import de.pauljako.airclient.ClientEntrypoint;
import de.pauljako.airclient.backend.Backend;
import de.pauljako.airclient.backend.BackendCallback;
import de.pauljako.airclient.cosmetics.CosmeticListener;
import de.pauljako.airclient.cosmetics.capes.Cape;
import de.pauljako.airclient.cosmetics.capes.CapeManager;
import java.io.File;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Collection;
import java.util.HashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class WebCapeLoader {
    private final CapeManager capeManager;
    private final HashMap<String, class_2960> capeCache = new HashMap();
    private final File capeCacheFile;
    private Json capeCacheObject = JsonParser.parse((String)"{}");

    public WebCapeLoader(CapeManager capeManager, File capeCacheFile) {
        this.capeManager = capeManager;
        this.capeCacheFile = capeCacheFile;
        if (capeCacheFile.exists()) {
            this.capeCacheObject = JsonParser.parse((File)capeCacheFile);
        }
    }

    public void searchCape(Backend backend, String name) {
        BackendCallback callback = (success, data) -> {
            if (!success) {
                return;
            }
            Cape cape = this.handleSendCapeData(data);
            if (cape == null) {
                return;
            }
            this.capeManager.addCape(cape);
        };
        Json jsonPacket = Json.empty().set("id", (Object)CosmeticListener.addCosmeticCallback(callback)).set("search", (Object)"cape").set("name", (Object)name);
        backend.send(jsonPacket);
    }

    public void allCapes(Backend backend) {
        BackendCallback callback = (success, data) -> {
            if (!success) {
                return;
            }
            for (JsonElement capeData : data.values()) {
                Cape cape = this.handleSendCapeData(JsonParser.parse((JsonElement)capeData));
                if (cape == null) {
                    return;
                }
                this.capeManager.addCape(cape);
            }
        };
        Json jsonPacket = Json.empty().set("id", (Object)CosmeticListener.addCosmeticCallback(callback)).set("all", (Object)"cape");
        backend.send(jsonPacket);
    }

    public Cape handleSendCapeData(Json data) {
        if (!data.contains("name") || !data.contains("url")) {
            return null;
        }
        if (data.contains("frames") && data.getInt("frames") != 1) {
            HashMap<Object, class_2960> resourceLocations = new HashMap<Object, class_2960>();
            for (int i = 0; i < data.getInt("frames"); ++i) {
                resourceLocations.put(data.getString("url") + "-" + i + ".png", class_2960.method_60655((String)"airclient-cache", (String)("textures/fetched/capes/" + data.getString("name") + "/frame_" + i + ".png")));
            }
            resourceLocations.forEach((url, location) -> this.fetchFromUrl((class_2960)location, (String)url));
            if (data.contains("delay")) {
                return new Cape(data.getString("name"), data.getInt("delay"), resourceLocations.values().toArray(new class_2960[0]));
            }
            return new Cape(data.getString("name"), resourceLocations.values().toArray(new class_2960[0]));
        }
        String url2 = data.getString("url") + ".png";
        class_2960 identifier = class_2960.method_60655((String)"airclient-cache", (String)("textures/fetched/capes/" + data.getString("name") + ".png"));
        this.fetchFromUrl(identifier, url2);
        return new Cape(data.getString("name"), identifier);
    }

    public void fetchFromUrl(class_2960 path, String url) {
        String replacedPath = path.toString().replace(".", "\\.") + "." + url.replace(".", "\\.");
        if (!this.getCapeCache().containsKey(url)) {
            byte[] response;
            if (this.getCapeCacheObject().contains(path.toString().replace(".", "\\.")) && this.getCapeCacheObject().contains(replacedPath)) {
                Collection responseCollection = this.getCapeCacheObject().getByteList(replacedPath);
                response = new byte[responseCollection.size()];
                int i2 = 0;
                for (Byte b : responseCollection) {
                    response[i2++] = b;
                }
            } else {
                try {
                    response = HttpClient.newHttpClient().send(HttpRequest.newBuilder().uri(new URI(url)).build(), HttpResponse.BodyHandlers.ofByteArray()).body();
                    Collection responseCollection = IntStream.range(0, response.length).mapToObj(i -> response[i]).collect(Collectors.toList());
                    this.getCapeCacheObject().set(replacedPath, (Object)responseCollection);
                    this.saveCapeCacheFile();
                }
                catch (Exception e) {
                    ClientEntrypoint.LOGGER.error(e.getMessage());
                    return;
                }
            }
            class_310.method_1551().execute(() -> {
                class_1043 nativeTexture = this.createNativeTexture(url, response);
                class_310.method_1551().method_1531().method_4616(path, (class_1044)nativeTexture);
                this.addCache(url, path);
            });
        }
    }

    private class_1043 createNativeTexture(String name, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return new class_1043(() -> name, class_1011.method_49277((byte[])bytes));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public HashMap<String, class_2960> getCapeCache() {
        return this.capeCache;
    }

    public File getCapeCacheFile() {
        return this.capeCacheFile;
    }

    public void addCache(String url, class_2960 path) {
        this.capeCache.put(url, path);
    }

    private void saveCapeCacheFile() {
        this.capeCacheObject.save(this.capeCacheFile);
    }

    public Json getCapeCacheObject() {
        return this.capeCacheObject;
    }
}

