/*
 * Decompiled with CFR 0.152.
 */
package de.pauljako.airclient.cosmetics.capes;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.pauljako.airclient.Client;
import de.pauljako.airclient.cosmetics.capes.Cape;
import de.pauljako.airclient.cosmetics.capes.WebCapeLoader;
import java.io.File;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class CapeManager {
    private final HashMap<UUID, Cape> setCapes = new HashMap();
    private final HashMap<String, Cape> capes = new HashMap();
    public final File capeCacheFile = new File(FabricLoader.getInstance().getGameDir().toFile(), "airclient-cape-cache.json");
    public final WebCapeLoader webCapeLoader = new WebCapeLoader(this, this.capeCacheFile);

    public void setForPlayer(UUID uuid, @Nullable Cape cape) {
        if (cape == null) {
            this.setCapes.remove(uuid);
        } else {
            this.setCapes.put(uuid, cape);
        }
    }

    public void setForPlayer(GameProfile profile, @Nullable Cape cape) {
        this.setForPlayer(profile.getId(), cape);
    }

    public void setForPlayer(UUID uuid, String name) {
        this.setForPlayer(uuid, this.getCape(name));
    }

    public void setForPlayer(GameProfile profile, String name) {
        this.setForPlayer(profile.getId(), this.getCape(name));
    }

    public void setActiveCape(@Nullable Cape cape) {
        this.setForPlayer(class_310.method_1551().method_53462().getId(), cape);
        Client.instance().getBackend().sendCosmetics();
        if (cape != null) {
            Client.instance().getConfig().set("cape", (Object)cape.name);
            Client.instance().saveConfig();
        } else if (Client.instance().getConfig().contains("cape")) {
            Client.instance().getConfig().remove("cape");
            Client.instance().saveConfig();
        }
    }

    public void setActiveCape(String name) {
        this.setForPlayer(class_310.method_1551().method_53462().getId(), this.getCape(name));
        Client.instance().getBackend().sendCosmetics();
        Client.instance().getConfig().set("cape", (Object)name);
        Client.instance().saveConfig();
    }

    public Cape getForPlayer(UUID uuid) {
        return this.setCapes.get(uuid);
    }

    public Cape getForPlayer(GameProfile profile) {
        return this.getForPlayer(profile.getId());
    }

    public void addCape(Cape cape) {
        this.capes.put(cape.getName(), cape);
    }

    public Cape getCape(String name) {
        block2: {
            boolean exists;
            if (name == null || name.isEmpty() || name.equals("none")) {
                return null;
            }
            if (this.capes.containsKey(name)) break block2;
            this.webCapeLoader.searchCape(Client.instance().getBackend(), name);
            long startTime = System.currentTimeMillis();
            long duration = 1000L;
            while (System.currentTimeMillis() - startTime < duration && !(exists = this.capes.containsKey(name))) {
            }
        }
        return this.capes.get(name);
    }

    public void init() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cape").executes(context -> {
            this.setActiveCape((Cape)null);
            return 1;
        })).then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new CapeSuggestionProvider()).executes(context -> {
            this.setActiveCape(StringArgumentType.getString((CommandContext)context, (String)"name"));
            return 1;
        }))));
    }

    public void tick() {
        this.setCapes.values().forEach(Cape::tick);
    }

    public class CapeSuggestionProvider
    implements SuggestionProvider<FabricClientCommandSource> {
        public CompletableFuture<Suggestions> getSuggestions(CommandContext<FabricClientCommandSource> context, SuggestionsBuilder builder) throws CommandSyntaxException {
            CapeManager.this.capes.keySet().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }
    }
}

