/*
 * Decompiled with CFR 0.152.
 */
package de.pauljako.airclient;

import de.craftsblock.craftscore.event.ListenerAdapter;
import de.craftsblock.craftscore.event.ListenerRegistry;
import de.craftsblock.craftscore.json.Json;
import de.craftsblock.craftscore.json.JsonParser;
import de.pauljako.airclient.ClientEntrypoint;
import de.pauljako.airclient.backend.Backend;
import de.pauljako.airclient.cosmetics.CosmeticListener;
import de.pauljako.airclient.cosmetics.PrefixManager;
import de.pauljako.airclient.cosmetics.capes.CapeManager;
import de.pauljako.airclient.cosmetics.capes.JsonCapeLoader;
import de.pauljako.airclient.gui.overlay.OverlayManager;
import de.pauljako.airclient.gui.overlay.overlays.FPSOverlay;
import de.pauljako.airclient.gui.overlay.overlays.KeyStrokesOverlay;
import de.pauljako.airclient.gui.screens.OverlaysScreen;
import de.pauljako.airclient.module.ModuleManager;
import de.pauljako.airclient.utils.ConditionQueue;
import de.pauljako.airclient.utils.UUIDMapper;
import java.io.File;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_437;
import net.minecraft.class_634;

public class Client {
    public static ListenerRegistry listeners = new ListenerRegistry();
    private final ModuleManager moduleManager;
    private final CapeManager capeManager;
    private final OverlayManager overlayManager;
    private final PrefixManager prefixManager;
    private final UUIDMapper uuidMapper;
    private final File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), "airclient.json");
    private final String cosmeticFilePath = "assets/airclient/cosmetics.json";
    private final ConcurrentLinkedQueue<UUID> players = new ConcurrentLinkedQueue();
    private final ConditionQueue conditionQueue = new ConditionQueue();
    private final Backend backend = new Backend();
    public boolean zoomEnabled = false;
    protected class_304 fullbrightKeyBinding;
    private boolean showOwnNametag = false;
    private class_304 showOwnNametagKeyBinding;
    private class_304 ZoomKeyBinding;
    private class_304 OverlayKeyBinding;
    private boolean zoomState = false;
    private int fov;
    private double gamma;
    private Json config;

    public Client() {
        this.uuidMapper = new UUIDMapper();
        this.prefixManager = new PrefixManager();
        this.moduleManager = new ModuleManager();
        this.capeManager = new CapeManager();
        this.overlayManager = new OverlayManager();
    }

    public static Client instance() {
        return ClientEntrypoint.getClient();
    }

    public static String getVersion() {
        return ((ModContainer)FabricLoader.getInstance().getModContainer("airclient").orElseThrow()).getMetadata().getVersion().getFriendlyString().replaceAll("-SNAPSHOT", "");
    }

    public static boolean isSnapshot() {
        return ((ModContainer)FabricLoader.getInstance().getModContainer("airclient").orElseThrow()).getMetadata().getVersion().getFriendlyString().contains("-SNAPSHOT");
    }

    protected void init() {
        listeners.register((ListenerAdapter)new CosmeticListener());
        this.showOwnNametagKeyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.airclient.show_own_nametag", class_3675.class_307.field_1668, 78, "category.airclient"));
        this.fullbrightKeyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.airclient.fullbright", class_3675.class_307.field_1668, 71, "category.airclient"));
        this.ZoomKeyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.airclient.zoom", class_3675.class_307.field_1668, 89, "category.airclient"));
        this.OverlayKeyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.airclient.open_overlay_menu", class_3675.class_307.field_1668, 344, "category.airclient"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (this.showOwnNametagKeyBinding.method_1436()) {
                this.setShowOwnNametag(!this.shouldShowOwnNametag());
            }
            while (this.fullbrightKeyBinding.method_1436()) {
                this.setFullbright(!this.isFullbright());
            }
            while (this.OverlayKeyBinding.method_1436()) {
                class_310.method_1551().method_1507((class_437)new OverlaysScreen(class_310.method_1551().field_1755));
            }
            this.zoomEnabled = this.ZoomKeyBinding.method_1434();
        });
        this.getCapeManager().init();
        this.getPrefixManager().init();
        JsonCapeLoader.loadCapes(this.getCapeManager(), this.getCosmeticFilePath());
        this.moduleManager.register(this.overlayManager);
        this.overlayManager.register(new FPSOverlay());
        this.overlayManager.register(new KeyStrokesOverlay());
        this.loadConfig();
    }

    public void loadConfig() {
        ClientEntrypoint.LOGGER.info("Loading Config");
        try {
            this.config = JsonParser.parse((File)this.configFile);
        }
        catch (Exception e) {
            ClientEntrypoint.LOGGER.error(e.getMessage());
            this.config = Json.empty();
        }
        try {
            if (this.config.contains("cape")) {
                this.getConditionQueue().register(() -> this.getCapeManager().setActiveCape(this.config.getString("cape")), this.getBackend()::isConnected);
            }
            if (this.config.contains("prefix")) {
                this.getPrefixManager().setActivePrefix(this.config.getString("prefix"));
            }
            if (this.config.contains("show_own_nametag")) {
                this.showOwnNametag = this.config.getBoolean("show_own_nametag");
            }
            if (this.config.contains("overlays")) {
                this.getOverlayManager().entries().forEach(overlay -> {
                    if (this.config.contains("overlays." + overlay.getName())) {
                        if (this.config.contains("overlays." + overlay.getName() + ".active")) {
                            overlay.setActive(this.config.getBoolean("overlays." + overlay.getName() + ".active"));
                        }
                        if (this.config.contains("overlays." + overlay.getName() + ".x")) {
                            overlay.setX(this.config.getInt("overlays." + overlay.getName() + ".x"));
                        }
                        if (this.config.contains("overlays." + overlay.getName() + ".y")) {
                            overlay.setY(this.config.getInt("overlays." + overlay.getName() + ".y"));
                        }
                        if (this.config.contains("overlays." + overlay.getName() + ".color")) {
                            overlay.setColor(this.config.getInt("overlays." + overlay.getName() + ".color"));
                        }
                        if (this.config.contains("overlays." + overlay.getName() + ".shadow")) {
                            overlay.setShadow(this.config.getBoolean("overlays." + overlay.getName() + ".shadow"));
                        }
                    }
                });
            }
            if (this.config.contains("backend_url")) {
                this.backend.url = this.config.getString("backend_url");
            }
            if (this.config.contains("fullbright")) {
                this.getConditionQueue().register(() -> this.setGamma(this.config.getBoolean("fullbright")), () -> class_310.method_1551().field_1690 != null);
            }
            ClientEntrypoint.LOGGER.info("Config Loaded!");
        }
        catch (Exception e) {
            ClientEntrypoint.LOGGER.error(e.getMessage());
        }
    }

    public void saveConfig() {
        try {
            this.config.save(this.configFile);
        }
        catch (Exception e) {
            ClientEntrypoint.LOGGER.error(e.getMessage());
        }
    }

    public Json getConfig() {
        return this.config;
    }

    public ModuleManager modules() {
        return this.moduleManager;
    }

    public CapeManager getCapeManager() {
        return this.capeManager;
    }

    public PrefixManager getPrefixManager() {
        return this.prefixManager;
    }

    public UUIDMapper getUuidMapper() {
        return this.uuidMapper;
    }

    public OverlayManager getOverlayManager() {
        return this.overlayManager;
    }

    public boolean shouldShowOwnNametag() {
        return this.showOwnNametag;
    }

    public String getCosmeticFilePath() {
        return this.cosmeticFilePath;
    }

    public void setShowOwnNametag(boolean value) {
        this.addToast((class_2561)class_2561.method_43471((String)"key.airclient.show_own_nametag"), (class_2561)(value ? class_2561.method_43471((String)"value.airclient.enabled") : class_2561.method_43471((String)"value.airclient.disabled")));
        this.showOwnNametag = value;
        this.config.set("show_own_nametag", (Object)value);
        this.saveConfig();
    }

    public boolean isFullbright() {
        return (Double)class_310.method_1551().field_1690.method_42473().method_41753() == 100.0;
    }

    public void setFullbright(boolean fullbright) {
        this.addToast((class_2561)class_2561.method_43471((String)"key.airclient.fullbright"), (class_2561)(fullbright ? class_2561.method_43471((String)"value.airclient.enabled") : class_2561.method_43471((String)"value.airclient.disabled")));
        this.setGamma(fullbright);
        this.config.set("fullbright", (Object)fullbright);
        this.saveConfig();
    }

    public void setGamma(boolean fullbright) {
        if (fullbright && !this.isFullbright()) {
            this.gamma = (Double)class_310.method_1551().field_1690.method_42473().method_41753();
            class_310.method_1551().field_1690.method_42473().method_41748((Object)100.0);
        } else if (!fullbright && this.isFullbright()) {
            class_310.method_1551().field_1690.method_42473().method_41748((Object)this.gamma);
        }
    }

    public void addToast(class_2561 title, class_2561 description) {
        class_310.method_1551().method_1566().method_1999((class_368)class_370.method_29047((class_310)class_310.method_1551(), (class_370.class_9037)class_370.class_9037.field_47583, (class_2561)title, (class_2561)description));
    }

    public void tick() {
        this.modules().tick();
        this.getCapeManager().tick();
        this.getConditionQueue().tick();
        if (this.zoomEnabled && !this.zoomState) {
            this.fov = (Integer)class_310.method_1551().field_1690.method_41808().method_41753();
            class_310.method_1551().field_1690.field_1914 = true;
            class_310.method_1551().field_1690.method_41808().method_41748((Object)30);
            this.zoomState = true;
        } else if (!this.zoomEnabled && this.zoomState) {
            class_310.method_1551().field_1690.field_1914 = false;
            class_310.method_1551().field_1690.method_41808().method_41748((Object)this.fov);
            this.zoomState = false;
        }
        class_634 connection = class_310.method_1551().method_1562();
        if (connection != null && this.backend.isConnected()) {
            ConcurrentLinkedQueue<UUID> current = new ConcurrentLinkedQueue<UUID>(connection.method_31363());
            this.players.removeIf(uuid -> !current.contains(uuid));
            current.removeIf(this.players::contains);
            if (!current.isEmpty()) {
                this.backend.send(JsonParser.parse((String)"{}").set("data", current.stream().map(UUID::toString).toList()));
                this.players.addAll(current);
            }
        }
        if (connection != null && class_310.method_1551().field_1724 != null) {
            this.backend.connect();
        } else {
            this.backend.disconnect();
        }
    }

    public ConditionQueue getConditionQueue() {
        return this.conditionQueue;
    }

    public Backend getBackend() {
        return this.backend;
    }
}

